//
//  CMS_HTTP_Test.m
//  Composr Mobile SDK
//
//  Created by Aaswini on 07/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
import XCTest
class CMS_HTTP_Test: XCTestCase {


    func setUp() {
        super.setUp()
        // Put setup code here. This method is called before the invocation of each test method in the class.
    }

    func tearDown() {
        // Put teardown code here. This method is called after the invocation of each test method in the class.
        super.tearDown()
    }

    func test_rawurlencode() {
        var inputString = "test encoding the url + something"
        var expectedOutput = "test%20encoding%20the%20url%20%2B%20something"
        XCTAssertTrue((CMS_HTTP.rawurlencode(inputString) == expectedOutput), "")
    }

    func test_json_decode() {
        var jsonString = "{\"test\":\"val\",\"test1\":\"val1\"}"
        var obj = CMS_HTTP.json_decode(jsonString)
        var expectedOutput = ["test": "val", "test1": "val1"]
        XCTAssertTrue(obj.isEqualToDictionary(expectedOutput), "")
    }

    func test_json_encode() {
        var inputDict = ["test": "val", "test1": "val1"]
        var expectedOutput = "{\"test1\":\"val1\",\"test\":\"val\"}"
        XCTAssertTrue((CMS_HTTP.json_encode(inputDict) == expectedOutput), "")
    }

    func test_get_base_url() {
        XCTAssertTrue((CMS_HTTP.get_base_url() == k_WEBSERVICES_DOMAIN), "")
    }

    func test_build_url() {
        var testUrl = CMS_HTTP.build_url(["param1": "value1", "param2": "value2"], "testZone")
        var expectedUrl = "\(k_WEBSERVICES_DOMAIN)/testZone/index.php?&param2=value2&param1=value1"
        XCTAssertTrue((testUrl == expectedUrl), "")
    }

    func test_http_download_file() {
        var url = "http://login.yahoo.com/config/login?"
        CMS_HTTP.http_download_file(url, true, nil, kHTTPTimeout, {(response: String) -> Void in
            print("\(response)")
        })
        //TODO: Need to find a way to test the completion handler.
        XCTFail("Testcase not implemented")
    }

    func test_has_network_connection() {
        XCTAssertTrue(CMS_HTTP.has_network_connection() == true, "I have a network connection. Why do you say NO ?")
    }
}